%% CALCULATING FREQUENCY AT THE FRONT-END OUTPUT

%%
clc;
clear all;
close all;


%%
C_int = 1e-12;          % Integration capacitance [F]
V_comp = 1;             % Comaparator's threshold voltage [V]
V_off = 0;              % Comaparator's offset voltage [V]
I1 = 22.1209e-6;        % Current in phase 1 [A]
I2 = 20.4119e-6;        % Current in phase 2 [A]
I_leak = 0;             % Leaking current [A]

% td = 25e-12;            % Delay time for capacitor discharge [s]


% Model without non-idealities
T1 = (V_comp*C_int)/I1;            % Period of spike train in phase 1 [s]
f1 = 1/T1                          % Frequency in phase 1 [Hz]
f1_MHz = f1/(1e6)                  % f1 in MHz


T2 = (V_comp*C_int)/I2;            % Period of spike train in phase 2 [s]
f2 = 1/T2                          % Frequency in phase 2 [Hz]
f2_MHz = f2/(1e6)                  % f2 in MHz


%% Integration capacitance calculation
T_ = 25e-9;
I_ = 20e-6;

C_ = I_*T_/V_comp










